//Caption: To Design an Low Pass FIR Filter
clc;
clear;
close;
wp= input('Enter the pass band edge (rad)= ');
ws= input('Enter the stop band edge (rad)= ');
ks= input('Enter the stop band attenuation (dB)= ');
//If 43<Ks<54 choose hamming window.
//To select N,order of filter.
N= (2*%pi*4)./(ws-wp); // k=4 for Hamming window.
N= ceil(N); //To round-off N to the next integer.
wc=(wp+(ws-wp)/2)./%pi
// To obtain FIR filter Impulse Response 'wft'
//And FIR Filter Frequency response 'wfm'
[wft,wfm,fr]=wfir('lp',N+1,[wc/2,0],'hm',[0,0]);
figure(1)
a = gca();
a.x_location = "origin";
a.y_location = "origin";
a.data_bounds = [0,-150;1,50];
plot(2*fr,20*log10(wfm),'r')
xlabel('Normalized Digital Frequency w--->')
ylabel('Frequency Response in dB H(jw)=')
title('Frequency Response of FIR LPF')
xgrid(1)
//Result
//Enter the pass band edge (rad)= 0.3*%pi
//Enter the stop band edge (rad)=  0.45*%pi
//Enter the stop band attenuation (dB)=  50
//N  =    54.  
//-->wc
// wc  =    0.375  
//-->disp(wft,'Impulse Response of FIR LPF=')
// Impulse Response of FIR LPF=   
//   column 1 to 7
//   0.0003609  - 0.0007195  - 0.0010869    1.575D-18    0.0016485    0.0015927  - 0.0010883  
//   column  8 to 14
//  - 0.0035703  - 0.0017009    0.0038764    0.0061896  - 5.965D-18  - 0.0090208  - 0.0082516  
//   column 15 to 21
//    0.0053105    0.0164428    0.0074408  - 0.0162551  - 0.0251602    1.191D-17    0.0359480  
//   column 22 to 28
//   0.0334760  - 0.0225187  - 0.0756838  - 0.0394776    0.1111441    0.2931653    0.375  
//   column 29 to 35
//   0.2931653    0.1111441  - 0.0394776  - 0.0756838  - 0.0225187    0.0334760    0.0359480  
//   column 36 to 42
//   1.191D-17  - 0.0251602  - 0.0162551    0.0074408    0.0164428    0.0053105  - 0.0082516  
//   column 43 to 49
//   - 0.0090208  - 5.965D-18    0.0061896    0.0038764  - 0.0017009  - 0.0035703  - 0.0010883  column 50 to 55
//   0.0015927    0.0016485    1.575D-18  - 0.0010869  - 0.0007195    0.0003609